Triggers = {}

include("campaigns/"..CAMPAIGN_NAME.."/Sectors/Triggers/end_trigger")
include("campaigns/"..CAMPAIGN_NAME.."/Sectors/Triggers/kill_watcher")
include("campaigns/"..CAMPAIGN_NAME.."/Sectors/Triggers/quest_watcher")

Triggers["center_point"] = 
{
	active = false, 
	effect_radius = 20, 
	position = { x = 257.44, y = -24.6, z = 0, f = 1.0}, 
	priority = 1.0, 
	think = "tf_center_point", 
	type = "quest", 
}

Triggers["spawn_raven"] = 
{
	active = false, 
	effect_radius = 9, 
	position = { y=-58.4, x=300.9, z=94, f=1 }, 
	priority = 1, 
	think = "tf_spawn_raven", 
	type = "quest", 
}

Triggers["spawn_jackal"] = 
{
	active = false, 
	effect_radius = 9, 
	position = { y=-58.4, x=300.9, z=94, f=1 }, 
	priority = 1, 
	think = "tf_spawn_jackal", 
	type = "quest", 
}

Triggers["move_raven"] = 
{
	active = false, 
	effect_radius = 9, 
	position = { y=-58.4, x=300.9, z=94, f=1 }, 
	priority = 1, 
	think = "tf_move_raven", 
	type = "quest", 
}

Triggers["move_jackal"] = 
{
	active = false, 
	effect_radius = 9, 
	position = { y=-58.4, x=300.9, z=94, f=1 }, 
	priority = 1, 
	think = "tf_move_jackal", 
	type = "quest", 
}

Triggers["patrol_0"] = 
{
	color = "0xFF0000", 
	direction = 1, 
	line_dir = 1, 
	patrol_type = "circle", 
	point_count = 7, 
	point_radius = 1, 
	position = { y=24.4, x=137.7, z=-1.3, f=1 }, 
	transfer_mode = "walk", 
	type = "patrol", 
	wait_style = "each", 
	wait_time = 3, 
	patrol_points = {{ x=137.668, y=24.3649, z=-1.33056},{ x=130.525, y=42.4474, z=-1.37754},{ x=109.59, y=42.3096, z=-1.4114},{ x=100.071, y=71.8075, z=-1.36028},{ x=93.3083, y=51.5891, z=-1.19145},{ x=117.536, y=55.5295, z=-1.56421},{ x=119.065, y=25.5688, z=-1.48122} }
}

Triggers["patrol_1"] = 
{
	color = "0xFF0000", 
	direction = 1, 
	line_dir = 1, 
	patrol_type = "circle", 
	point_count = 7, 
	point_radius = 1, 
	position = { y=31.9, x=32.1, z=-0.8, f=1 }, 
	transfer_mode = "walk", 
	type = "patrol", 
	wait_style = "random", 
	wait_time = 5, 
	patrol_points = {{ x=32.1427, y=31.9336, z=-0.755383},{ x=35.6453, y=43.651, z=-0.807796},{ x=49.3127, y=47.7188, z=-0.977238},{ x=49.6825, y=61.3947, z=-0.893112},{ x=72.6846, y=88.7155, z=-1.47007},{ x=61.6745, y=111.269, z=-1.32774},{ x=35.6326, y=134.476, z=-1.2348} }
}

Triggers["checkpoint"] = 
{
	active = false, 
	effect_radius = 3.0, 
	position = { x = 299.5, y = -90.5, z = 95.8, f = 1.0}, 
	priority = 1.0, 
	think = "tf_checkpoint", 
	type = "quest", 
}

Triggers["relations_vs_army"] = 
{
	active = false, 
	effect_radius = 3, 
	position = { y=75.3, x=150.5, z=77.6, f=1 }, 
	priority = 1, 
	think = "tf_relations_vs_army", 
	type = "quest", 
}

Triggers["kill_striker"] = 
{
	active = false, 
	effect_radius = 3, 
	position = { y=75.3, x=150.5, z=77.6, f=1 }, 
	priority = 1, 
	think = "tf_kill_striker", 
	type = "quest", 
}

trigger_functions =
{
tf_spawn_raven = function(trigger_id, time)
	local trigger = Triggers[trigger_id]
	if(trigger.active == true) then
		local all, alive = countUnits(ARMY)
		
		if (all ~= 0) then
			local percent = alive / all
			if (percent < 0.20) then
				CAN_EXIT = false
				
				trigger.active = false
				
				spawnHuman(MARAUDERS, "raven")
				
				for count = 1, 10, 1 do
					spawnHuman(MARAUDERS, "mara_"..tostring(count))
				end
				
				setGVAR("spawn_raven_mi", _YES)
				
				addEntry("j_mar_03", false)
				
				changeLocalRelations(ENEMY, MARAUDERS)
				
				Triggers["move_raven"].active = true
			end
		end
	end
end,
tf_spawn_jackal = function(trigger_id, time)
	local trigger = Triggers[trigger_id]
	if(trigger.active == true) then
		local all, alive = countUnits(ARMY)
		
		if (all ~= 0) then
			local percent = alive / all
			if (percent < 0.20) then
				CAN_EXIT = false
				
				trigger.active = false
				
				spawnHuman(MARAUDERS, "jackal")
				
				for count = 1, 10, 1 do
					spawnHuman(MARAUDERS, "mara_"..tostring(count))
				end
				
				setGVAR("spawn_jackal_mi", _YES)
				
				addEntry("j_mar_03", false)
				
				changeLocalRelations(ENEMY, MARAUDERS)
				
				Triggers["move_jackal"].active = true
			end
		end
	end
end,
tf_move_raven = function(trigger_id, time)
	local trigger = Triggers[trigger_id]
	if(trigger.active == true) then
		local cm = getClosestMerc("raven", CUR_MISSION.Mercs)
		local x, y, z, f = getPosition(cm)
		local dist = service.person2person_distance("raven", cm)
		
		if (isGameInRT()  and (dist > 10)) then
			if (healthOK("raven") and canIssueOrder("raven") and idle("raven")) then
				local nx, ny, nz = service.pointAlongPointToPersonLine(x, y, z, "raven", dist - 10)
				stop("raven")
				addSmartMove("raven", "run", nx, ny, nz, f)
				Humans["raven"].busy = 2
				executeOrders("raven")
			end
			
			for count = 1, 10, 1 do
				if (healthOK("mara_"..tostring(count)) and canIssueOrder("mara_"..tostring(count)) and idle("mara_"..tostring(count))) then
					local nx, ny, nz = service.pointAlongPointToPersonLine(x, y, z, "mara_"..tostring(count), dist - 10)
					stop("mara_"..tostring(count))
					addSmartMove("mara_"..tostring(count), "run", nx, ny, nz, f)
					Humans["mara_"..tostring(count)].busy = 2
					executeOrders("mara_"..tostring(count))
				end
			end
		elseif (dist < 11) then
			trigger.active = false
		end
	end
end,
tf_move_jackal = function(trigger_id, time)
	local trigger = Triggers[trigger_id]
	if(trigger.active == true) then
		local cm = getClosestMerc("jackal", CUR_MISSION.Mercs)
		local x, y, z, f = getPosition(cm)
		local dist = service.person2person_distance("jackal", cm)
		
		if (isGameInRT() and (dist > 10)) then
			if (healthOK("jackal") and canIssueOrder("jackal") and idle("jackal")) then
				local nx, ny, nz = service.pointAlongPointToPersonLine(x, y, z, "jackal", dist - 10)
				stop("jackal")
				addSmartMove("jackal", "run", nx, ny, nz, f)
				Humans["jackal"].busy = 2
				executeOrders("jackal")
			end
			
			for count = 1, 10, 1 do
				if (healthOK("mara_"..tostring(count)) and canIssueOrder("mara_"..tostring(count)) and idle("mara_"..tostring(count))) then
					local nx, ny, nz = service.pointAlongPointToPersonLine(x, y, z, "mara_"..tostring(count), dist - 10)
					stop("mara_"..tostring(count))
					addSmartMove("mara_"..tostring(count), "run", nx, ny, nz, f)
					Humans["mara_"..tostring(count)].busy = 2
					executeOrders("mara_"..tostring(count))
				end
			end
		elseif (dist < 11) then
			trigger.active = false
		end
	end
end,
tf_checkpoint = function(trigger_id, time)
	local trigger = Triggers[trigger_id]
	if(trigger.active == true) then
		if (isGameInRT()) then
			if (getGVAR("spawn_army_mi") == _YES) then
				checkPointer("mines", trigger_id, {"officer_1", "guard_1"}, "checkpoint_remark1", "checkpoint_remark2", "docu_check", 10, time, true, 30, "checkpoint_remark3", false, 7)
				checkPointer("mines", trigger_id, {"officer_2", "guard_2"}, "checkpoint_remark1", "checkpoint_remark2", "docu_check", 10, time, true, 30, "checkpoint_remark3", false, 7)
			else
				trigger.active = false
			end
		end
	end
end,
tf_relations_vs_army = function(trigger_id, time)
	local trigger = Triggers[trigger_id]
	if(trigger.active == true) then
		changeLocalRelations(ENEMY, ARMY)
		trigger.active = false
	end
end,
tf_kill_striker = function(trigger_id, time)
	local trigger = Triggers[trigger_id]
	if(trigger.active == true) then
		sound2D("Weapons/Ps/aps_s")
		setPersonParameter("striker", "HEALTH", 0)
		trigger.active = false
	end
end,
--
-- end trigger
--
tf_end_trigger = CommonTriggers.end_trigger,
--
-- kill watcher trigger
--
tf_kill_watcher = CommonTriggers.kill_watcher,
--
-- quest watcher trigger
--
tf_quest_watcher = CommonTriggers.quest_watcher,
--
-- honey point for bees
--
tf_center_point = CommonTriggers.center_point,
}
